\name{Tdverg}
\alias{Tdverg}
\title{
Time of divergence between populations
}
\description{
This function returns a matrix of the time of divergence between populations in generation
}
\usage{
Tdverg(Fst, All_H)
}
\arguments{
  \item{Fst}{
a distance matrix with Fst values estimates using Reynolds
}
  \item{All_H}{
a text file with a list of the long-term Ne for each population, with an header that match the population labels reported in the FST matrix
}
}
\details{
This function applies the following formula for each pair of populations: T= ln (1-FST)/ln(1-1/2Ne), where Ne is the mean of the long-term Ne for the considered pair of populations. It is possible to obtain the confidence intervals of the divergence time using the 5th and 95th percentile of the long-term Ne (calculated from Ne_CI) as input.
The order of the populations into the Fst matrix and into the vector of Ne could be different but the names of the populations must be the same in each item.
}
\value{
a matrix with the time of divergence between population measured as generations
}
\references{
Hayes, B. J., Visscher, P. M., McPartlan, H. C., & Goddard, M. E. (2003). Novel multilocus measure of linkage disequilibrium to estimate past effective population size. Genome Research, 13(4), 635-643.

Tenesa, A., Navarro, P., Hayes, B. J., Duffy, D. L., Clarke, G. M., Goddard, M. E., & Visscher, P. M. (2007). Recent human effective population size estimated from linkage disequilibrium. Genome research, 17(4), 520-526.

McEvoy, B. P., Powell, J. E., Goddard, M. E., & Visscher, P. M. (2011). Human population dispersal 'Out of Africa' estimated from linkage disequilibrium and allele frequencies of SNPs. Genome research, 21(6), 821-829
}
\seealso{
'Ne_CI'
}



