Nemap<-function(bim.file, map.file){
       BIM<-read.table(bim.file)
	   NEWBIM<-c()
           for (i in 1:22){
                map<-read.table(paste(map.file,i,".txt", sep=""),h=T)
                bim<-subset(BIM, BIM$V1==i)
                y<-match(map$Position.bp.,bim$V4)
                bim1<-bim[na.omit(y),]
                x<-match(bim1$V4, map$Position.bp.)
                map1<-map[x,]
                bim1$V3=map1$Map.cM.
                NEWBIM<-rbind(NEWBIM, bim1)
				}
				return(NEWBIM)
				}
NeUpdate<-function(plink.file, snp.list, outfile){
          print("Creating new PLINK file...")
          system(paste("./plink --bfile ",plink.file," --extract ",snp.list," --noweb --make-bed --out ",outfile, sep=""),ignore.stdout = TRUE, ignore.stderr = TRUE)
          print("Updating bim file..")
          BIM<-read.table(paste(outfile,".bim",sep=""))
          NEWBIM<-read.table(snp.list)
          NEWBIM1<-c()
          for (i in 1:22){
	           bim<-subset(BIM, BIM$V1==i)
	           newbim<-subset(NEWBIM,NEWBIM$V1==i)	
			   x<-match(bim$V4, newbim$V4)
	           newbim1<-newbim[na.omit(x),]
	           NEWBIM1<-rbind(NEWBIM1,newbim1)
                }			
			write.table(NEWBIM1,paste(outfile,".bim",sep=""), row.names=F,quote=F,col.names=F)
            print("Done!")
			}	
				
				

NeLD<-function(plink.file, geno=0.02, mind=0.9, ld.window.kb=500,ld.window=9999, outfile="output.ld"){
       system(paste("./plink --bfile ",plink.file," --noweb --geno ",geno," --mind ",mind," --make-bed --out ",outfile, sep=""),ignore.stdout = TRUE, ignore.stderr = TRUE)
       map<-read.table(paste(outfile,".bim",sep=""))
       map1=map
	   map1$V2=map$V3
       write.table(map1,outfile, row.names=F,quote=F,col.names=F)
	   system(paste("mv ", outfile," ",outfile,".bim ",sep=""))
	   print("LD calculation,(it will take a while)")
       system(paste("./plink --bfile ",outfile," --noweb --r2 --ld-window-kb ",ld.window.kb, " --ld-window ",ld.window," --ld-window-r2 0 --out ",outfile, sep=""), ignore.stdout = TRUE, ignore.stderr = TRUE)
       print("Done!")
	   }


Nestimate<-function(file.ld, sample.size, min.R2=0.001,max.R2=0.999, method="MG",min.cfr=5){
	a<-read.table(file.ld, h=T)
	n<-sample.size
	distance_kb<-(a[,"BP_B"]-a[,"BP_A"])/1000
	distance_cM<-((a[,"SNP_B"]-a[,"SNP_A"]))
	CM<-((a[,"SNP_B"]-a[,"SNP_A"]))*1000
	b<-cbind(a[,c(1,7)],distance_kb,distance_cM,CM)
	b1<-b[which(b$distance_cM>0),]
	b2<-b1[which(b1$R2>=min.R2),]
	b3<-b2[which(b2$R2<=max.R2),]                                 
	chr<-c()
	bin<-c()
	t<-c()
	Ne<-c()
	i=5
	k=1
	method=method
	Ne.tot=c()
	chr.tot=c()
	bin.tot=c()
	t.tot=c()
	for(k in 1:22){
		chr<-subset(b3, b3$CHR_A==k)  
		if (method=="MG"){
		    for(i in 5:250){
			bin<-subset(chr,chr$CM>=i & chr$CM<=(i+5))
			if (length(bin[,1])>min.cfr){
				r2=bin$R2
				r2=mean(r2)-(1/n)
				c<-(bin$distance_cM)/100
				t=1/(2*mean(c))
				Ne<-(1/(4*c))*((1/r2)-2)
				Ne<-mean(Ne)
				t.tot=c(t.tot,t)
				Ne.tot=c(Ne.tot,Ne)
				bin.tot=c(bin.tot,i)
				chr.tot=c(chr.tot,k) 
			}
		}
	}
	if (method=="McEvoy") {
	   for(i in 1:50){
			bin<-subset(chr,chr$CM>=(5*i) & chr$CM<=((5*i)+5))
			if (length(bin[,1])>min.cfr){
				r2=bin$R2
				r2=mean(r2)-(1/n)
				c<-(bin$distance_cM)/100
				t=1/(2*mean(c))
				Ne<-(1/(4*c))*((1/r2)-2)
				Ne<-mean(Ne)
				t.tot=c(t.tot,t)
				Ne.tot=c(Ne.tot,Ne)
				bin.tot=c(bin.tot,i)
				chr.tot=c(chr.tot,k) 
			}
		}
	}
   
}	
res.fin<-data.frame(Chr=chr.tot,Bin=bin.tot,Ne=Ne.tot,Time=t.tot)
	output<-na.omit(res.fin)
	for ( i in 1:length(output[,1])){
		if (output[i,"Ne"]<0) 
			output[i,"Ne"]=NA
			}
	output<-na.omit(output)
	output<-round(output, digit=0)
	
return(output)	
}

Ne_CI<-function(Nestimate.output,ci=c(0.05,0.5,0.95)){
		   library(psych)
	       chr<-c()
		   Hmean<-c()
	       for( i in 1:22){
		   chr<-subset(Nestimate.output, Nestimate.output$Chr==i)
		   hmean<-harmonic.mean(chr$Ne)
		   Hmean<-rbind(Hmean,hmean)
	        }
	       CI<-quantile(Hmean, ci, na.rm=TRUE)
		   CI<-round(CI, digit=0)
	       return(CI)
}

Ne_Med<-function(Nestimate.output, method="MG", ci=FALSE, ci.int=c(0.05,0.5,0.95)){	
        if (method=="MG"){
	        m<-c()
	        ne<-c()
	        ti<-c()
	        NE<-c()
	        T<-c()
	for (m in 5:250){
	    if (ci=="FALSE"){
		m<-subset(Nestimate.output,Nestimate.output$Bin==m)
		ne<-median(m$Ne)
		ti<-median(m$Time)
		}
		if (ci=="TRUE"){
		m<-subset(Nestimate.output,Nestimate.output$Bin==m)
		ne<-quantile(m$Ne,ci.int)
		ti<-median(m$Time)
				}
		T<-c(T,ti)
		NE<-rbind(NE,ne)
	}
 }	
if (method=="McEvoy"){
	m<-c()
	ne<-c()
	ti<-c()
	NE<-c()
	T<-c()
	for (m in 1:50){
if (ci=="FALSE"){
		m<-subset(Nestimate.output,Nestimate.output$Bin==m)
		ne<-median(m$Ne)
		ti<-median(m$Time)
		}
		if (ci=="TRUE"){
		m<-subset(Nestimate.output,Nestimate.output$Bin==m)
		ne<-quantile(m$Ne,ci.int)
		ti<-median(m$Time)
				}
		T<-c(T,ti)
		NE<-rbind(NE,ne)
	}
 }	

	MED<-cbind(T,NE)
	MED<-as.data.frame(MED)
	if (ci=="FALSE"){
    colnames(MED)=c("T", "50%")
	}
	MED<-round(MED, digit=0)
return(MED)
}	

Neplot<-function(Ne.file,approx=TRUE,ylim=c(0,15000),xlim=c(200,6000), main="Ne from linkage disequilibrium",xlab="Generation ago", ylab="Ne",ci=TRUE){
	if (approx=="TRUE"){
		if (ci=="TRUE"){
		a<-read.table(Ne.file,h=T)
		plot(approx(a$T,a$X50.), type="l", col="red", ylab=ylab, main=main, xlab=xlab, ylim=ylim, xlim=xlim)
		lines(approx(a$T,a$X5.), type="l", col="blue",lty=2,)
		lines(approx(a$T,a$X95.), type="l", col="blue",lty=2)
		}
        if (ci=="FALSE"){
		a<-read.table(Ne.file,h=T)
		plot(approx(a$T,a$X50.), type="l", col="red", ylab=ylab, main=main, xlab=xlab, ylim=ylim, xlim=xlim)
		}	
	}
   	if (approx=="FALSE"){
		if (ci=="TRUE"){
			a<-read.table(Ne.file,h=T)
			plot(a$T,a$X50., type="l", col="red", ylab=ylab, main=main, xlab=xlab, ylim=ylim, xlim=xlim)
			lines(a$T,a$X5., type="l", col="blue",lty=2,pch=1)
			lines(a$T,a$X95., type="l", col="blue",lty=2,pch=1)
		}
        if (ci=="FALSE"){
			a<-read.table(Ne.file,h=T)
			plot(a$T,a$X50., type="l", col="red", ylab=ylab, main=main, xlab=xlab, ylim=ylim, xlim=xlim)
		}	
	}

}


Tdverg<-function(Fst,All_H){
	Fst<-read.table(Fst, fill=T, row.names=1,h=T,sep="\t")
	Fst1<-as.dist(Fst, upper=T, diag=T)
	Fst1<-as.matrix(Fst1)
	All_H<-read.table(All_H,h=T)
	ne=matrix(nrow=length(All_H),ncol=length(All_H))
	t=matrix(nrow=length(All_H),ncol=length(All_H))
	T<-as.data.frame(t)
	Ne<-as.data.frame(ne)
	row.names(Ne)=colnames(All_H)
	names(Ne)=colnames(All_H)
	for ( i in 1:length(All_H)){
		for (j in 1:length(All_H)){
			Ne[i,j]=mean(c(All_H[,i],All_H[,j]))
		}
	}
	neword<-match(row.names(Ne),row.names(Fst1))
	Fst2<-Fst1[cbind(neword),cbind(neword)]
	row.names(T)=row.names(Fst2)
	colnames(T)=colnames(Fst2)
	for ( i in 1:length(All_H)){
		for (j in 1:length(All_H)){
			T[i,j]=log(1-Fst2[i,j])/log(1-(1/(2*Ne[i,j])))
		}
	}
return(T)
}	

