\name{Ne_Med}
\alias{Ne_Med}
\title{Estimation of the effective population size over time 
}
\description{
This function calculates the demographic function(effective population size over time) of a population along with its confidence interval, for each bin.
}
\usage{
Ne_Med(Nestimate.output, method = 'MG', ci = FALSE, 
ci.int = c(0.05, 0.5, 0.95))
}
\arguments{
  \item{Nestimate.output}{
   a dataframe obtained from  the Nestimate function
}
  \item{method}{
   two possible methods used for estimate the Ne in Nestimate: 'Mcevoy' or 'MG', (default 'MG')
}
  \item{ci}{
   if confidence intervals must be calculated, (default FALSE)
}
  \item{ci.int}{
  if ci=TRUE which quantiles of the distribution must be calculated, (default 5th, 50th and 95th percentile)
}
}
\details{
 Ne_Med takes the output of Nestimate and calculates the median of effective population (calculated from all autosomes) estimated for each temporal point, depending of the method used to estimate Ne: 'McEvoy' or 'MG' you could have 50 or 250 temporal points, you must specify the method used.
In addition you could estimate different quantiles of the distribution of Ne for each temporal point.
}
\value{
This function returns a dataframe with the first three columns indicating the quantiles of the distribution of the effective population size for each bin over all chromosomes (the default values are the 90 percent  confidence interval and the median value) and the last column with the moment in time to which the effective population size is referred (1/2c generation ago). 
}
\references{
McEvoy, B. P., Powell, J. E., Goddard, M. E., & Visscher, P. M. (2011). Human population dispersal ,'Out of Africa' estimated from linkage disequilibrium and allele frequencies of SNPs. Genome research, 21(6), 821-829
}
\seealso{
'Nestimate'
}




