\name{Nestimate}
\alias{Nestimate}
\title{
Estimation of effective population size from linkage disequilibrium}
\description{
This function estimates the effective population size from linkage disequilibrium
}
\usage{
Nestimate(file.ld, sample.size, min.R2 = 0.001, max.R2 = 0.999,
method = 'MG', min.cfr = 5)
}
\arguments{
  \item{file.ld}{
output file from PLINK linkage disequilibrium analysis
}
  \item{sample.size}{
number of individuals used to estimate r^2 into the population
}
  \item{min.R2}{
minimum value of r^2 allowed into each comparison, default(0.001)
}
  \item{max.R2}{
maximum value of r^2 allowed into each comparison default(0.999)
}
  \item{method}{
two possible method are allowed to estimate Ne trough generations: 'MG' and 'McEvoy', default 'MG'
}
  \item{min.cfr}{
minimum number of comparison in each bin that are allowed to estimate the mean Ne into each bin, (default 5) 
}
}
\details{
This function estimate the demography of the population using each chromosome as an independent replicates,it applies the well-known formula Ne= 1/(4c) * [(1/r2) - 2],where c is the distance between genetic markers in Morgan. Nestimate creates several categories of recombination distance ,with incremental upper boundaries of 0.005 centiMorgan (cM) up to 0.25 cM, and calculates the  r2 for each pairs of markers in each recombination distance category. 
Two methods of binning are possible:
the first one is identical to the method used into McEvoy et al. were 50 bins were created, each bin correspond to a specific intervals and are not overlapping,
the second method 'MG' (Mezzavilla-Ghirotto) created 250 bins that are overlapping, in this way we have more bins and more temporal points in which we could estimate the
effective population size this could provide a fine scale of demography reconstruction
}
\value{
a dataframe with the values of the effective population size and the correspondent time in the past (in generation), for each bin, for each chromosome. 
}
\references{
Hayes, B. J., Visscher, P. M., McPartlan, H. C., & Goddard, M. E. (2003). Novel multilocus measure of linkage disequilibrium to estimate past effective population size. Genome Research, 13(4), 635-643.

Tenesa, A., Navarro, P., Hayes, B. J., Duffy, D. L., Clarke, G. M., Goddard, M. E., & Visscher, P. M. (2007). Recent human effective population size estimated from linkage disequilibrium. Genome research, 17(4), 520-526

McEvoy, B. P., Powell, J. E., Goddard, M. E., & Visscher, P. M. (2011). Human population dispersal ,'Out of Africa' estimated from linkage disequilibrium and allele frequencies of SNPs. Genome research, 21(6), 821-829
}
\note{
We suggest to no decrease the min.cfr under 5, in order to have reliable estimates of Ne
}
\seealso{
'Ne_Med', 'Ne_CI','NeLd'
}

